using System;
using System.Data;
using System.Reflection;
using Common = gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using SHIPMENT = gov.va.med.vbecs.Common.VbecsTables.Shipment;
using BLOODUNITSHIPMENT = gov.va.med.vbecs.Common.VbecsTables.BloodUnitShipment;

namespace gov.va.med.vbecs.BOL
{
		#region Header

    ///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
    ///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
    ///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
    ///<Developers>
    ///	<Developer>Cameron Taylor</Developer>
    ///	<Developer>Mike      </Developer>
    ///	<Developer>Luke Meyer</Developer>
    ///	<Developer>Carl Jensen</Developer>
    ///</Developers>
    ///<SiteName>Hines OIFO</SiteName>
    ///<CreationDate>9/17/2002</CreationDate>
    ///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
    ///<summary>
    ///Base Shipment business layer object
    ///</summary>

		#endregion

    public class BaseShipment : BaseBusinessObject
    {
		#region Variables

        private DataTable _shipmentDataTable;
        private DataRow  _shipmentDataRow;

		#endregion

		#region Constructors
        //
		#if NUNIT

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1541"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>BaseShipment object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5064"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BaseShipment
		/// </summary>
		public BaseShipment()
		{
			this.MakeNew();
		}

		#else
		/// <summary>
		/// BaseShipment
		/// </summary>
		protected BaseShipment()
        {
			this.MakeNew();
        }
		#endif

		/// <summary>
		/// BaseShipment
		/// </summary>
		/// <param name="shipmentGuid">Shipment Guid</param>
		protected BaseShipment(System.Guid shipmentGuid) : this()
		{
			GetShipmentData(shipmentGuid);
		}

		#endregion
		
		#region Methods

        /// <summary>
        /// GetShipmentData
        /// </summary>
        /// <param name="shipmentGuid">Shipment Guid</param>
        private void GetShipmentData(System.Guid shipmentGuid)
        {
            ShipmentDataTable = DAL.Shipment.GetShipment(shipmentGuid);

            if (ShipmentDataTable.Rows.Count > 0) 
            {
                ShipmentDataRow = ShipmentDataTable.Rows[0];
            }
            else 
            {
                MakeNew(shipmentGuid);
            }

			ShipmentDataTable.Rows[0].AcceptChanges();
            ShipmentDataTable.ColumnChanged += new DataColumnChangeEventHandler(this.OnColumnChanged);
        }
        /// <summary>
        /// MakeNew
        /// </summary>
        protected virtual void MakeNew()
        {
            
            ShipmentDataRow = ShipmentDataTable.NewRow();
            //
            this.ShipmentGuid = Guid.Empty;
            this.LocalSupplierGuid = Guid.Empty;
            this.InvoiceNumber = this.GenerateNewInvoiceNumber(VBECSDateTime.GetDivisionCurrentDateTime());
            this.ShipmentDirection = true;
            this.LastUpdateDate = DateTime.MinValue;
            this.LastUpdateUser = Common.LogonUser.LogonUserName;
            this.RowVersion = null; 
			this.DivisionCode = Common.LogonUser.LogonUserDivisionCode;		//Added because of Stas's DB change

            ShipmentDataTable.Rows.Add(ShipmentDataRow);
            this.IsNew = true;
        }
		
		/// <summary>
		/// MakeNew
		/// </summary>
		/// <param name="shipmentGuid">Shipment Guid</param>
		protected virtual void MakeNew(Guid shipmentGuid)
		{
			ShipmentDataRow = ShipmentDataTable.NewRow();
			//
			this.ShipmentGuid = shipmentGuid;
			this.LastUpdateUser = Common.LogonUser.LogonUserName;
			

			this.LocalSupplierGuid = Guid.Empty;
			this.InvoiceNumber = this.GenerateNewInvoiceNumber(VBECSDateTime.GetDivisionCurrentDateTime());
			this.ShipmentDirection = true;
			this.LastUpdateDate = DateTime.MinValue;
			this.LastUpdateUser = Common.LogonUser.LogonUserName;
			this.RowVersion = null; 
			this.DivisionCode = Common.LogonUser.LogonUserDivisionCode;		//Added because of Stas's DB change
           
			ShipmentDataTable.Rows.Add(ShipmentDataRow);
			this.IsNew = true;
		}



		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2402"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Null</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2407"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Public function to return a data row of the given data table schema, populated by blood property object properties
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dataRow)
		{
			//NOT USED
			return null;
		}

		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dataRow"></param>
		protected override void LoadFromDataRow(DataRow dataRow)
		{

			//NOT USED
			return;
		}


		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/28/2003</CreationDate>
		/// <summary>
		/// Generates a new invoice number
		/// </summary>
		private string GenerateNewInvoiceNumber(DateTime dateTime)
		{
			//This is not used as a date but rather as a autogenerated number
			try
			{
				return dateTime.ToString("yyyyMMddhhmmss");
			}
			catch
			{
				return VBECSDateTime.GetDivisionCurrentDateTime().ToString("yyyyMMddhhmmss");
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/19/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3661"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList of DataTables</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3662"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns an empty Shipment Table
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static System.Collections.ArrayList InitializeShipmentTable(bool isUpdate)
		{
			System.Collections.ArrayList dtArray = new System.Collections.ArrayList();

			DataTable dtShipment = new DataTable(Common.VbecsTables.Shipment.TableName);

			dtShipment.Columns.Add(SHIPMENT.ShipmentGuid, typeof(Guid));
			dtShipment.Columns.Add(SHIPMENT.ShipmentDirection, typeof(byte));
			dtShipment.Columns.Add(SHIPMENT.ShipmentDate, typeof(DateTime));
			dtShipment.Columns.Add(SHIPMENT.InvoiceNumber, typeof(string));
			dtShipment.Columns.Add(SHIPMENT.LocalSupplierGuid, typeof(Guid));
			dtShipment.Columns.Add(SHIPMENT.ProductShipperGuid, typeof(Guid));
			dtShipment.Columns.Add(SHIPMENT.DivisionCode, typeof(string));
			dtShipment.Columns.Add(SHIPMENT.LastUpdateUser, typeof(string));
			if(isUpdate)
				dtShipment.Columns.Add(SHIPMENT.RowVersion, typeof(byte[]));

			DataTable dtBloodUnitShipment = new DataTable(Common.VbecsTables.BloodUnitShipment.TableName);
			
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.BloodUnitShipmentGuid, typeof(Guid));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.BloodUnitGuid, typeof(Guid));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.IncomingShipmentGuid, typeof(Guid));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.OutgoingShipmentGuid, typeof(Guid));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.LoginBloodProductGuid, typeof(Guid));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.LoginFullProductCode, typeof(string));
			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.LoginValues, typeof(string));
		


			dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.LastUpdateUser, typeof(string));
			if (isUpdate)
				dtBloodUnitShipment.Columns.Add(BLOODUNITSHIPMENT.RowVersion, typeof(byte[]));

			dtArray.Add(dtShipment);
			dtArray.Add(dtBloodUnitShipment);

			return dtArray;
		}

		/// <summary>
		/// CreateShipmentDataTable - Added by Hackdiana Jones
		/// </summary>
		protected void CreateShipmentDataTable()
		{
			_shipmentDataTable = new System.Data.DataTable();

			_shipmentDataTable.Columns.Add(SHIPMENT.LocalSupplierGuid,typeof(System.Guid));
			_shipmentDataTable.Columns.Add(SHIPMENT.ProductShipperGuid, typeof(System.Guid));
			_shipmentDataTable.Columns.Add(SHIPMENT.InvoiceNumber,typeof(String));
			_shipmentDataTable.Columns.Add(SHIPMENT.ShipmentDate,typeof(DateTime));
			_shipmentDataTable.Columns.Add(SHIPMENT.ShipmentDirection,typeof(bool));
			_shipmentDataTable.Columns.Add(SHIPMENT.ShipmentGuid,typeof(System.Guid));
			_shipmentDataTable.Columns.Add(SHIPMENT.ShipmentTypeCode,typeof(String));
			_shipmentDataTable.Columns.Add(SHIPMENT.ShipmentTemperature,typeof(short));
			_shipmentDataTable.Columns.Add(SHIPMENT.DivisionCode,typeof(String));
			_shipmentDataTable.Columns.Add(SHIPMENT.LastUpdateDate,typeof(DateTime));
			_shipmentDataTable.Columns.Add(SHIPMENT.LastUpdateUser,typeof(String));
			_shipmentDataTable.Columns.Add(SHIPMENT.RowVersion,typeof(Byte[]));
		}

        /// <summary>
        /// GetOriginalBloodUnitShipper
        /// </summary>
        /// <param name="bloodUnitGuid"></param>
        /// <returns></returns>
        public static DataTable GetOriginalBloodUnitShipper(Guid bloodUnitGuid)
        {
            return DAL.Shipment.GetOriginalBloodUnitShipper(bloodUnitGuid);
        }

		#endregion

		#region Properties

		/// <summary>
		/// ShipmentDataTable
		/// </summary>
		protected internal DataTable ShipmentDataTable
		{
			get
			{
				if (_shipmentDataTable == null)
				{
					//TODO: This should never be null, figure out why this is accomodated
					this.CreateShipmentDataTable();
				}
				return _shipmentDataTable;
			}
			set
			{
				_shipmentDataTable = value;
			}
		}
		
		/// <summary>
		/// ShipmentDataRow
		/// </summary>
		protected internal DataRow ShipmentDataRow
		{
			get
			{
				return _shipmentDataRow;
			}
			set
			{
				_shipmentDataRow = value;
			}
		}
		
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3331"> 
		///		<ExpectedInput>GUID</ExpectedInput>
		///		<ExpectedOutput>GUID</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5065"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Shipment GUID
        /// </summary>
        public System.Guid ShipmentGuid 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.ShipmentGuid))
                {
                    return System.Guid.Empty;
                }
                return (System.Guid)ShipmentDataRow[SHIPMENT.ShipmentGuid];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.ShipmentGuid] = value;
            } 

        }
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3333"> 
		///		<ExpectedInput>GUID</ExpectedInput>
		///		<ExpectedOutput>GUID</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5066"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Local supplier GUID
        /// </summary>
        public System.Guid LocalSupplierGuid 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.LocalSupplierGuid))
                {
                    return System.Guid.Empty;
                }
                return (System.Guid)ShipmentDataRow[SHIPMENT.LocalSupplierGuid];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.LocalSupplierGuid] = value;
            } 

        }
		 
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/5/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7360"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7361"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///	Product Shipper Guid
		/// </summary>
		public System.Guid ProductShipperGuid 
		{
			get
			{
				if (ShipmentDataRow.IsNull(SHIPMENT.ProductShipperGuid))
				{
					return System.Guid.Empty;
				}
				return (System.Guid)ShipmentDataRow[SHIPMENT.ProductShipperGuid];
			}
			set
			{
				ShipmentDataRow[SHIPMENT.ProductShipperGuid] = value;
			} 

		}
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3335"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3336"> 
		///		<ExpectedInput>Invalid InvoiceNumber</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Invoice #
        /// </summary>
        public string InvoiceNumber 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.InvoiceNumber))
                {
                    return string.Empty;
                }
                return (string)ShipmentDataRow[SHIPMENT.InvoiceNumber];
            }
            set
            {
                if (value == null || value.Length > 14)
                {
                    throw new ArgumentException("Invalid InvoiceNumber argument", "value");
                }
                ShipmentDataRow[SHIPMENT.InvoiceNumber] = value;
            } 

        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3353"> 
		///		<ExpectedInput>date</ExpectedInput>
		///		<ExpectedOutput>date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5067"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Shipment Date
        /// </summary>
        public System.DateTime ShipmentDate 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.ShipmentDate))
                {
                    return System.DateTime.MinValue;
                }
                return (System.DateTime)ShipmentDataRow[SHIPMENT.ShipmentDate];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.ShipmentDate] = value;
            } 

        }
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3337"> 
		///		<ExpectedInput>boolean</ExpectedInput>
		///		<ExpectedOutput>boolean</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5068"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Shipment direction
        /// </summary>
        public bool ShipmentDirection 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.ShipmentDirection))
                {
                    return false;
                }
                return (bool)ShipmentDataRow[SHIPMENT.ShipmentDirection];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.ShipmentDirection] = value;
            } 

        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3339"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3340"> 
		///		<ExpectedInput>Invalid shipment type code</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Shipment type code
        /// </summary>
        public string ShipmentTypeCode 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.ShipmentTypeCode))
                {
                    return "0";
                }
                return (string)ShipmentDataRow[SHIPMENT.ShipmentTypeCode];
            }
            set
            {
                if (value == null || value.Length > 1)
                {
                    throw new ArgumentException("Invalid ShipmentTypeCode argument", "value");
                }
                ShipmentDataRow[SHIPMENT.ShipmentTypeCode] = value;
            } 

        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3341"> 
		///		<ExpectedInput>Valid temperature</ExpectedInput>
		///		<ExpectedOutput>Valid short</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5069"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Shipment temperature
        /// </summary>
        public System.Int16 ShipmentTemperature 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.ShipmentTemperature))
                {
                    return new System.Int16();
                }
                return (System.Int16)ShipmentDataRow[SHIPMENT.ShipmentTemperature];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.ShipmentTemperature] = value;
            } 

        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3343"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3344"> 
		///		<ExpectedInput>Invalid division code</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Division code
        /// </summary>
        public string DivisionCode 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.DivisionCode))
                {
                    return Common.LogonUser.LogonUserDivisionCode;
                }
                return (string)ShipmentDataRow[SHIPMENT.DivisionCode];
            }
            set
            {
                if (value == null || value.Length > 5)
                {
                    throw new ArgumentException("Invalid DivisionCode argument", "value");
                }
                ShipmentDataRow[SHIPMENT.DivisionCode] = value;
            } 
        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3345"> 
		///		<ExpectedInput>date</ExpectedInput>
		///		<ExpectedOutput>date</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5070"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Last update date
        /// </summary>
        public new System.DateTime LastUpdateDate 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.LastUpdateDate))
                {
                    return System.DateTime.MinValue;
                }
                return (System.DateTime)ShipmentDataRow[SHIPMENT.LastUpdateDate];
            }
            set
            {
                ShipmentDataRow[SHIPMENT.LastUpdateDate] = value;
            } 

        }

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3347"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3348"> 
		///		<ExpectedInput>Invalid user</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Last update user
        /// </summary>
        public new string LastUpdateUser 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.LastUpdateUser))
                {
                    return string.Empty;
                }
                return (string)ShipmentDataRow[SHIPMENT.LastUpdateUser];
            }
            set
            {
                if (value == null || value.Length > 30)
                {
                    throw new ArgumentException("Invalid LastUpdateUser argument", "value");
                }
                ShipmentDataRow[SHIPMENT.LastUpdateUser] = value;
            } 

        }
        
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3349"> 
		///		<ExpectedInput>byte array</ExpectedInput>
		///		<ExpectedOutput>byte array</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5071"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// RowVersion
        /// </summary>
        public new System.Byte[] RowVersion 
        {
            get
            {
                if (ShipmentDataRow.IsNull(SHIPMENT.RowVersion))
                {
                    return null;
                }
                return (System.Byte[])ShipmentDataRow[SHIPMENT.RowVersion];
            }
			set 
			{
				if (value == null)
				{
					ShipmentDataRow[SHIPMENT.RowVersion] = System.DBNull.Value;
				}
				else
				{
					ShipmentDataRow[SHIPMENT.RowVersion] = value;
				}
			}

        }

		#endregion
		
		#region Events / Event Handlers

		private void OnColumnChanged(object sender, DataColumnChangeEventArgs eventArgs)
		{
			this.IsDirty = true;
		}

		#endregion
	}
}